package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import androidx.room.OnConflictStrategy;

import com.ekoapp.ekosdk.TaggedEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject;
import com.google.common.collect.FluentIterable;

import java.util.List;

public abstract class EkoTagDao<EntityType extends EkoTagObject> {

    static <TaggedObject extends TaggedEkoObject, TagObject extends EkoTagObject> void update(List<TaggedObject> ekoObjects, EkoTagDao<TagObject> dao, EkoTagObject.EkoTagFactory<TagObject> factory) {
        for (TaggedObject ekoObject : ekoObjects) {
            update(ekoObject, dao, factory);
        }
    }

    static <TagObject extends EkoTagObject> void update(TaggedEkoObject ekoObject, EkoTagDao<TagObject> dao, EkoTagObject.EkoTagFactory<TagObject> factory) {
        String[] tags = ekoObject.getTags().toArray(new String[0]);

        List<TagObject> list = FluentIterable.from(tags)
                .transform(tag -> factory.create(ekoObject.getId(), tag))
                .toList();

        dao.insert(list);
        dao.retainAll(ekoObject.getId(), tags);
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract void insert(List<EntityType> objects);

    abstract void retainAll(String id, String[] tags);
}
