package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.FOLLOWER_QUERY_TOKEN_TABLE_NAME
import com.ekoapp.ekosdk.internal.data.model.FollowerQueryToken
import io.reactivex.Completable
import io.reactivex.Maybe

@Dao
abstract class FollowerQueryTokenDao : AmityPagingTokenDao<FollowerQueryToken> {

    @RawQuery(observedEntities = [FollowerQueryToken::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<FollowerQueryToken>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: FollowerQueryToken): Completable

    override fun tableName() = FOLLOWER_QUERY_TOKEN_TABLE_NAME
}