package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.FOLLOWING_QUERY_TOKEN_TABLE_NAME
import com.ekoapp.ekosdk.internal.data.model.FollowingQueryToken
import io.reactivex.Completable
import io.reactivex.Maybe

@Dao
abstract class FollowingQueryTokenDao : AmityPagingTokenDao<FollowingQueryToken> {

    @RawQuery(observedEntities = [FollowingQueryToken::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<FollowingQueryToken>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: FollowingQueryToken): Completable

    override fun tableName() = FOLLOWING_QUERY_TOKEN_TABLE_NAME
}