package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.entity.GlobalPostEntity


@Dao
abstract class GlobalPostDao : EkoObjectDao<GlobalPostEntity>() {

    @Query("DELETE from global_post")
    abstract override fun deleteAll()

    @Query("SELECT rank from global_post where pageNumber = 1 order by rank DESC LIMIT 1")
    abstract fun getHighestRank(): Int


}