package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;

import com.amity.socialcloud.sdk.core.user.AmityUserSortOption;
import com.amity.socialcloud.sdk.social.community.AmityQuerySortingOrder;
import com.ekoapp.ekosdk.UserEntity;

import java.util.List;

import io.reactivex.Flowable;

@Dao
public abstract class UserDao extends EkoObjectDao<UserEntity> implements AmityPagingDao<UserEntity> {

    @Query(
            "SELECT *" +
                    " from user, user_query_token" +
                    " where (user.displayName like '%' || :keyword || '%' or user.userId like '%' || :keyword || '%')" +
                    " and" +
                    " (user_query_token.keyword = :keyword" +
                    " and user_query_token.sortBy = :sortBy" +
                    " and user_query_token.pageNumber = 1" +
                    " and user_query_token.ids like '%' || user.userId || '%')" +
                    " order by " +
                    " case when :isTimeRelatedColumn = 1 and :isSortedAsc = 1 then user.createdAt end asc," +
                    " case when :isTimeRelatedColumn = 1 and :isSortedAsc = 0 then user.createdAt end desc," +
                    " case when :isTimeRelatedColumn = 0 then user.displayName end asc"
    )
    abstract DataSource.Factory<Integer, UserEntity> getDataSourceImpl(String keyword, String sortBy, Boolean isTimeRelatedColumn, Boolean isSortedAsc);

    public DataSource.Factory<Integer, UserEntity> getDataSource(String keyword, AmityUserSortOption sortBy) {
        Boolean isTimeRelatedColumn = sortBy.getSortingColumn().equals(AmityUserSortOption.FIRST_CREATED.getSortingColumn()) || sortBy.getSortingColumn().equals(AmityUserSortOption.LAST_CREATED.getSortingColumn());
        return getDataSourceImpl(keyword, sortBy.getApiKey(), isTimeRelatedColumn, sortBy.getSortingOrder().equals(AmityQuerySortingOrder.ASC.getSqlOrder()));
    }

    @Query(
            "SELECT *" +
                    " from user, user_query_token" +
                    " where (user.displayName like '%' || :keyword || '%' or user.userId like '%' || :keyword || '%')" +
                    " and" +
                    " (user_query_token.keyword = :keyword" +
                    " and user_query_token.sortBy = :sortBy" +
                    " and user_query_token.ids like '%' || user.userId || '%')" +
                    " order by user.displayName asc"
    )
    abstract PagingSource<Integer, UserEntity> getPagingSourceImpl(String keyword, String sortBy);

    public PagingSource<Integer, UserEntity> getPagingSource(String keyword, AmityUserSortOption sortBy) {
        return getPagingSourceImpl(keyword, sortBy.getApiKey());
    }

    @Query("SELECT *" +
            " from user" +
            " where user.userId = :userId" +
            " LIMIT 1")
    abstract io.reactivex.rxjava3.core.Flowable<UserEntity> getByIdImpl(String userId);

    public io.reactivex.rxjava3.core.Flowable<UserEntity> getById(String userId) {
        return getByIdImpl(userId);
    }

    @Query("SELECT *" +
            " from user" +
            " where user.userId IN (:userId)")
    abstract io.reactivex.rxjava3.core.Flowable<List<UserEntity>> observeUserImpl(String userId);

    public io.reactivex.rxjava3.core.Flowable<List<UserEntity>> observeUser(String userId) {
        return observeUserImpl(userId);
    }

    @Query("DELETE from user where userId = :userId")
    public abstract void deleteById(String userId);

    @Query("SELECT *" +
            " from user" +
            " where user.userId = :userId" +
            " LIMIT 1")
    abstract UserEntity getByIdNowImpl(String userId);

    public UserEntity getByIdNow(String userId) {
        return getByIdNowImpl(userId);
    }

    @Query("SELECT *" +
            " from user" +
            " where user.userId IN (:userIds)")
    abstract List<UserEntity> getByIdsNowImpl(List<String> userIds);

    @Override
    public List<UserEntity> getByIdsNow(List<String> ids) {
        return getByIdsNowImpl(ids);
    }

    @Query("DELETE from user")
    public abstract void deleteAll();
}
