package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.*
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.USER_FEED_QUERY_TOKEN_TABLE_NAME
import com.ekoapp.ekosdk.internal.data.model.UserFeedQueryTokenEntity
import io.reactivex.Completable
import io.reactivex.Maybe

@Dao
abstract class UserFeedQueryTokenDao : AmityPagingTokenDao<UserFeedQueryTokenEntity> {

    @RawQuery(observedEntities = [UserFeedQueryTokenEntity::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<UserFeedQueryTokenEntity>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: UserFeedQueryTokenEntity): Completable

    override fun tableName() = USER_FEED_QUERY_TOKEN_TABLE_NAME
}