package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.UserQueryTokenEntity
import com.ekoapp.ekosdk.internal.data.model.USER_QUERY_TOKEN_TABLE_NAME
import io.reactivex.Completable
import io.reactivex.Maybe

@Dao
abstract class UserQueryTokenDao : AmityPagingTokenDao<UserQueryTokenEntity> {

    @RawQuery(observedEntities = [UserQueryTokenEntity::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<UserQueryTokenEntity>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: UserQueryTokenEntity): Completable

    override fun tableName() = USER_QUERY_TOKEN_TABLE_NAME
}