package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName = "channel_permission",
        primaryKeys = {"channelId", "userId", "permissionName"},
        foreignKeys = {
                @ForeignKey(entity = ChannelMembershipEntity.class,
                        parentColumns = {"channelId", "userId"},
                        childColumns = {"channelId", "userId"},
                        onDelete = ForeignKey.CASCADE)
        })
public class ChannelMembershipPermissionEntity extends EkoPermissionObject {

    @NonNull
    private String channelId;

    @NonNull
    private String userId;

    @NonNull
    private String permissionName;

    @NonNull
    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(@NonNull String channelId) {
        this.channelId = EkoPreconditions.checkValidId(channelId, "channelId");
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    @NonNull
    public String getPermissionName() {
        return permissionName;
    }

    public void setPermissionName(@NonNull String permissionName) {
        this.permissionName = EkoPreconditions.checkValidId(permissionName, "permissionName");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        ChannelMembershipPermissionEntity other = (ChannelMembershipPermissionEntity) obj;
        return Objects.equal(channelId, other.channelId)
                && Objects.equal(userId, other.userId)
                && Objects.equal(permissionName, other.permissionName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                channelId,
                userId,
                permissionName
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("channelId", channelId)
                .add("userId", userId)
                .add("permissionName", permissionName)
                .toString();
    }

    public static ChannelMembershipPermissionEntity create(@NonNull String channelId, @NonNull String userId, @NonNull String permissionName) {
        ChannelMembershipPermissionEntity channelPermission = new ChannelMembershipPermissionEntity();
        channelPermission.setChannelId(channelId);
        channelPermission.setUserId(userId);
        channelPermission.setPermissionName(permissionName);
        return channelPermission;
    }
}
