package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName = "channel_role",
        primaryKeys = {"channelId", "userId", "roleName"},
        foreignKeys = {
                @ForeignKey(entity = ChannelMembershipEntity.class,
                        parentColumns = {"channelId", "userId"},
                        childColumns = {"channelId", "userId"},
                        onDelete = ForeignKey.CASCADE)
        })
public class ChannelMembershipRoleEntity extends EkoRoleObject {

    @NonNull
    private String channelId;

    @NonNull
    private String userId;

    @NonNull
    private String roleName;

    @NonNull
    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(@NonNull String channelId) {
        this.channelId = EkoPreconditions.checkValidId(channelId, "channelId");
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    @NonNull
    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(@NonNull String roleName) {
        this.roleName = EkoPreconditions.checkValidId(roleName, "roleName");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        ChannelMembershipRoleEntity other = (ChannelMembershipRoleEntity) obj;
        return Objects.equal(channelId, other.channelId)
                && Objects.equal(userId, other.userId)
                && Objects.equal(roleName, other.roleName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                channelId,
                userId,
                roleName
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("channelId", channelId)
                .add("userId", userId)
                .add("roleName", roleName)
                .toString();
    }

    public static ChannelMembershipRoleEntity create(@NonNull String channelId, @NonNull String userId, @NonNull String roleName) {
        ChannelMembershipRoleEntity channelRole = new ChannelMembershipRoleEntity();
        channelRole.setChannelId(channelId);
        channelRole.setUserId(userId);
        channelRole.setRoleName(roleName);
        return channelRole;
    }
}
