package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName = "community_permission",
        primaryKeys = {"communityId", "userId", "permissionName"},
        foreignKeys = {
                @ForeignKey(entity = CommunityMembershipEntity.class,
                        parentColumns = {"communityId", "userId"},
                        childColumns = {"communityId", "userId"},
                        onDelete = ForeignKey.CASCADE)
        })
public class CommunityMembershipPermissionEntity extends EkoPermissionObject {

    @NonNull
    private String communityId;

    @NonNull
    private String userId;

    @NonNull
    private String permissionName;

    @NonNull
    public String getCommunityId() {
        return communityId;
    }

    public void setCommunityId(@NonNull String communityId) {
        this.communityId = EkoPreconditions.checkValidId(communityId, "communityId");
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    @NonNull
    public String getPermissionName() {
        return permissionName;
    }

    public void setPermissionName(@NonNull String permissionName) {
        this.permissionName = EkoPreconditions.checkValidId(permissionName, "permissionName");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        CommunityMembershipPermissionEntity other = (CommunityMembershipPermissionEntity) obj;
        return Objects.equal(communityId, other.communityId)
                && Objects.equal(userId, other.userId)
                && Objects.equal(permissionName, other.permissionName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                communityId,
                userId,
                permissionName
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("communityId", communityId)
                .add("userId", userId)
                .add("permissionName", permissionName)
                .toString();
    }

    public static CommunityMembershipPermissionEntity create(@NonNull String communityId, @NonNull String userId, @NonNull String permissionName) {
        CommunityMembershipPermissionEntity communityPermission = new CommunityMembershipPermissionEntity();
        communityPermission.setCommunityId(communityId);
        communityPermission.setUserId(userId);
        communityPermission.setPermissionName(permissionName);
        return communityPermission;
    }
}
