package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName = "community_role",
        primaryKeys = {"communityId", "userId", "roleName"},
        foreignKeys = {
                @ForeignKey(entity = CommunityMembershipEntity.class,
                        parentColumns = {"communityId", "userId"},
                        childColumns = {"communityId", "userId"},
                        onDelete = ForeignKey.CASCADE)
        })
public class CommunityMembershipRoleEntity extends EkoRoleObject {

    @NonNull
    private String communityId;

    @NonNull
    private String userId;

    @NonNull
    private String roleName;

    @NonNull
    public String getCommunityId() {
        return communityId;
    }

    public void setCommunityId(@NonNull String communityId) {
        this.communityId = EkoPreconditions.checkValidId(communityId, "communityId");
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    @NonNull
    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(@NonNull String roleName) {
        this.roleName = EkoPreconditions.checkValidId(roleName, "roleName");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        CommunityMembershipRoleEntity other = (CommunityMembershipRoleEntity) obj;
        return Objects.equal(communityId, other.communityId)
                && Objects.equal(userId, other.userId)
                && Objects.equal(roleName, other.roleName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                communityId,
                userId,
                roleName
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("communityId", communityId)
                .add("userId", userId)
                .add("roleName", roleName)
                .toString();
    }

    public static CommunityMembershipRoleEntity create(@NonNull String communityId, @NonNull String userId, @NonNull String roleName) {
        CommunityMembershipRoleEntity communityRole = new CommunityMembershipRoleEntity();
        communityRole.setCommunityId(communityId);
        communityRole.setUserId(userId);
        communityRole.setRoleName(roleName);
        return communityRole;
    }
}
