package com.ekoapp.ekosdk.internal.data.model

import co.amity.rxremotemediator.AmityQueryToken
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.ekosdk.community.membership.query.AmityCommunityMembership

class CommunityMembershipSearchQueryToken(
    var communityId: String = "",
    var roles: AmityRoles = AmityRoles(),
    var filters: List<AmityCommunityMembership>? = null,
    var keyword: String? = null,
    next: String? = null,
    previous: String? = null,
    ids: List<String> = listOf()
) : AmityQueryToken(
    queryParameters = mapOf(
        "communityId" to communityId,
        "roles" to roles,
        "memberships" to (filters ?: listOf()),
        "search" to (keyword ?: "")
    ),
    next = next,
    previous = previous,
    primaryKeys = ids
)