package com.ekoapp.ekosdk.internal.data.model

import co.amity.rxremotemediator.AmityQueryToken
import timber.log.Timber

class CommunityQueryToken(
	keyword: String,
	categoryId: String,
	filter: String,
	sortBy: String,
	isDeleted: Boolean = false,
	next: String? = null,
	previous: String? = null,
	ids: List<String> = listOf()
) : AmityQueryToken(
		queryParameters = mapOf(
				"keyword" to keyword,
				"categoryId" to categoryId,
				"filter" to filter,
				"sortBy" to sortBy,
				"isDeleted" to isDeleted
		),
		next = next,
		previous = previous,
		primaryKeys = ids
)