package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

import com.google.common.base.Objects;

@Entity(tableName = "baidu_token")
public class EkoBaiduToken {

    @PrimaryKey
    @NonNull
    private String id = "SINGLETON_BAIDU_TOKEN";
    @Nullable
    private String token;
    @Nullable
    private String userId;
    @Nullable
    private String channelId;
    @NonNull
    private String apiKey;


    public EkoBaiduToken(@NonNull String apiKey) {
        this.apiKey = apiKey;
    }

    @NonNull
    public String getId() {
        return id;
    }

    public void setId(@NonNull String id) {
        this.id = id;
    }

    @Nullable
    public String getToken() {
        return token;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    @Nullable
    public String getUserId() {
        return userId;
    }

    public void setUserId(@Nullable String userId) {
        this.userId = userId;
    }

    @Nullable
    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(@Nullable String channelId) {
        this.channelId = channelId;
    }

    @NonNull
    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(@NonNull String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoBaiduToken other = (EkoBaiduToken) obj;
        return Objects.equal(id, other.id)
                && Objects.equal(token, other.token)
                && Objects.equal(userId, other.userId)
                && Objects.equal(channelId, other.channelId)
                && Objects.equal(apiKey, other.apiKey);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id, token, userId, channelId, apiKey);
    }
}
