package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName = "category",
        primaryKeys = {"communityId", "categoryId"},
        foreignKeys = {
                @ForeignKey(entity = CommunityEntity.class,
                        parentColumns = "communityId",
                        childColumns = "communityId",
                        onDelete = ForeignKey.CASCADE)
        })
public class EkoCategoryEntity extends EkoCategoryObject {

    @NonNull
    private String communityId;
    @NonNull
    private String categoryId;

    @NonNull
    public String getCommunityId() {
        return communityId;
    }

    public void setCommunityId(@NonNull String communityId) {
        this.communityId = communityId;
    }

    @NonNull
    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(@NonNull String categoryId) {
        this.categoryId = categoryId;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoCategoryEntity other = (EkoCategoryEntity) obj;
        return Objects.equal(communityId, other.communityId)
                && Objects.equal(categoryId, other.categoryId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                communityId,
                categoryId
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("communityId", communityId)
                .add("categoryId", categoryId)
                .toString();
    }

    public static EkoCategoryEntity create(@NonNull String communityId, @NonNull String categoryId) {
        EkoCategoryEntity categoryEntity = new EkoCategoryEntity();
        categoryEntity.setCommunityId(communityId);
        categoryEntity.setCategoryId(categoryId);
        return categoryEntity;
    }
}
