package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipFilter
import com.amity.socialcloud.sdk.core.permission.AmityRoles

internal const val CHANNEL_MEMBERSHIP_QUERY_TOKEN_TABLE_NAME = "channel_membership_query_token"

@Entity(
    tableName = CHANNEL_MEMBERSHIP_QUERY_TOKEN_TABLE_NAME,
    primaryKeys = ["channelId", "roles", "filter", "sortBy", "pageNumber"]
)
class EkoChannelMembershipQueryToken : EkoQueryToken() {
    lateinit var channelId: String
    lateinit var roles: AmityRoles
    lateinit var filter: AmityChannelMembershipFilter
    lateinit var sortBy: String
}