package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName = "channel_tag",
        primaryKeys = {"channelId", "tagName"},
        foreignKeys = {
                @ForeignKey(entity = EkoChannelEntity.class,
                        parentColumns = "channelId",
                        childColumns = "channelId",
                        onDelete = ForeignKey.CASCADE)
        })
public class EkoChannelTag extends EkoTagObject {

    @NonNull
    private String channelId;
    @NonNull
    private String tagName;

    @NonNull
    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(@NonNull String channelId) {
        this.channelId = EkoPreconditions.checkValidId(channelId, "channelId");
    }

    @NonNull
    public String getTagName() {
        return tagName;
    }

    public void setTagName(@NonNull String tagName) {
        this.tagName = EkoPreconditions.checkValidId(tagName, "tagName");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoChannelTag other = (EkoChannelTag) obj;
        return Objects.equal(channelId, other.channelId)
                && Objects.equal(tagName, other.tagName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                channelId,
                tagName
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("channelId", channelId)
                .add("tagName", tagName)
                .toString();
    }

    public static EkoChannelTag create(@NonNull String channelId, @NonNull String tagName) {
        EkoChannelTag channelTag = new EkoChannelTag();
        channelTag.setChannelId(channelId);
        channelTag.setTagName(tagName);
        return channelTag;
    }
}
