package com.ekoapp.ekosdk.internal.data.model;

import android.annotation.SuppressLint;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.amity.socialcloud.sdk.chat.data.message.MessageRepository;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

import hu.akarnokd.rxjava3.bridge.RxJavaBridge;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;

@Entity(tableName = "message_flag",
        primaryKeys = {"messageId"},
        foreignKeys = {
                @ForeignKey(entity = EkoMessageEntity.class,
                        parentColumns = "messageId",
                        childColumns = "messageId",
                        onDelete = ForeignKey.CASCADE)
        })
public class EkoMessageFlag extends EkoObject {

    @NonNull
    private String messageId;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    private EkoLocalFlag localFlag;

    @Override
    public String getId() {
        return null;
    }

    @NonNull
    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(@NonNull String messageId) {
        this.messageId = messageId;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public void setFlag(EkoFlag flag) {
        this.flag = flag;
    }

    public EkoLocalFlag getLocalFlag() {
        return localFlag;
    }

    public void setLocalFlag(EkoLocalFlag localFlag) {
        this.localFlag = localFlag;
    }

    @SuppressLint("CheckResult")
    public boolean isFlaggedByMe() {
        if (flag != null) {
            boolean mightFlaggedByMe = flag.mightFlaggedByMe();

            if (localFlag == null) {
                localFlag = new EkoLocalFlag();
            }

            if (mightFlaggedByMe && !Objects.equal(flag.getHash(), localFlag.getSyncedUpHash())) {
                Single.just(messageId)
                        .filter(flag::expired)
                        .flatMapSingle((Function<String, SingleSource<Boolean>>) messageId ->
                                RxJavaBridge.toV2Single(new MessageRepository().isFlaggedByMe(messageId))
                        )
                        .subscribe(isFlaggedByMe -> {
                            localFlag.setFlaggedByMe(isFlaggedByMe);
                            localFlag.setSyncedUpHash(flag.getHash());
                            UserDatabase.get().messageFlagDao().update(this);
                        }, Throwable::printStackTrace);

                return true;
            }

            return mightFlaggedByMe && localFlag.isFlaggedByMe();
        } else if (localFlag != null) {
            Completable.fromAction(() -> {
                localFlag = null;
                UserDatabase.get().messageFlagDao().update(this);
            }).subscribeOn(Schedulers.io()).subscribe();
        }

        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj)
                && Objects.equal(flag, ((EkoMessageFlag) obj).flag)
                && Objects.equal(localFlag, ((EkoMessageFlag) obj).localFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), flag, localFlag);
    }

}
