package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.core.AmityTags

internal const val MESSAGE_QUERY_TOKEN_TABLE_NAME = "message_query_token"

@Entity(
    tableName = MESSAGE_QUERY_TOKEN_TABLE_NAME,
    primaryKeys = ["channelId", "parentId", "includingTags", "excludingTags", "includingIsDeleted", "isFilterByParentId", "pageNumber"]
)
class EkoMessageQueryToken : EkoQueryToken() {
    lateinit var channelId: String
    lateinit var parentId: String
    lateinit var includingTags: AmityTags
    lateinit var excludingTags: AmityTags
    var includingIsDeleted = false
    var isFilterByParentId = false
}