package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName = "message_tag",
        primaryKeys = {"messageId", "tagName"},
        foreignKeys = {
                @ForeignKey(entity = EkoMessageEntity.class,
                        parentColumns = "messageId",
                        childColumns = "messageId",
                        onDelete = ForeignKey.CASCADE)
        })
public class EkoMessageTag extends EkoTagObject {

    @NonNull
    private String messageId;
    @NonNull
    private String tagName;

    @NonNull
    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(@NonNull String messageId) {
        this.messageId = EkoPreconditions.checkValidId(messageId, "messageId");
    }

    @NonNull
    public String getTagName() {
        return tagName;
    }

    public void setTagName(@NonNull String tagName) {
        this.tagName = EkoPreconditions.checkValidId(tagName, "tagName");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoMessageTag other = (EkoMessageTag) obj;
        return Objects.equal(messageId, other.messageId)
                && Objects.equal(tagName, other.tagName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                messageId,
                tagName
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("messageId", messageId)
                .add("tagName", tagName)
                .toString();
    }

    public static EkoMessageTag create(@NonNull String messageId, @NonNull String tagName) {
        EkoMessageTag messageTag = new EkoMessageTag();
        messageTag.setMessageId(messageId);
        messageTag.setTagName(tagName);
        return messageTag;
    }
}
