package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.amity.socialcloud.sdk.social.data.post.PostRepository;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;

@Entity(tableName = "post_flag",
        primaryKeys = {"postId"},
        foreignKeys = {
                @ForeignKey(entity = PostEntity.class,
                        parentColumns = "postId",
                        childColumns = "postId",
                        onDelete = ForeignKey.CASCADE)
        })
public class EkoPostFlag extends EkoObject {

    @NonNull
    private String postId;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    private EkoLocalFlag localFlag;

    @Override
    public String getId() {
        return null;
    }

    @NonNull
    public String getPostId() {
        return postId;
    }

    public void setPostId(@NonNull String postId) {
        this.postId = postId;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public void setFlag(EkoFlag flag) {
        this.flag = flag;
    }

    public EkoLocalFlag getLocalFlag() {
        return localFlag;
    }

    public void setLocalFlag(EkoLocalFlag localFlag) {
        this.localFlag = localFlag;
    }

    public boolean isFlaggedByMe() {
        if (flag != null) {
            boolean mightFlaggedByMe = flag.mightFlaggedByMe();

            if (localFlag == null) {
                localFlag = new EkoLocalFlag();
            }

            if (mightFlaggedByMe && !Objects.equal(flag.getHash(), localFlag.getSyncedUpHash())) {
                Single.just(postId)
                        .filter(flag::expired)
                        .flatMapSingle(new PostRepository()::isFlaggedByMe)
                        .doOnSuccess(response -> {
                            localFlag.setFlaggedByMe(response.get("result").getAsBoolean());
                            localFlag.setSyncedUpHash(flag.getHash());
                            UserDatabase.get().postFlagDao().update(this);
                        })
                        .subscribe();

                return true;
            }

            return mightFlaggedByMe && localFlag.isFlaggedByMe();
        } else if (localFlag != null) {
            Completable.fromAction(() -> {
                localFlag = null;
                UserDatabase.get().postFlagDao().update(this);
            }).subscribeOn(Schedulers.io()).subscribe();
        }

        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj)
                && Objects.equal(flag, ((EkoPostFlag) obj).flag)
                && Objects.equal(localFlag, ((EkoPostFlag) obj).localFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), flag, localFlag);
    }

}
