package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;

import com.google.common.base.Objects;

@Entity(tableName = "push_config", primaryKeys = {"userId", "deviceId"})
public class EkoPushConfig {

    public enum State {
        REGISTERED("registered"),
        UNREGISTERED("unregistered");

        private final String apiKey;


        State(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getApiKey() {
            return apiKey;
        }


        public static State fromApiKey(String apiKey) {
            for (State state : values()) {
                if (Objects.equal(apiKey, state.apiKey)) {
                    return state;
                }
            }
            return null;
        }
    }

    @NonNull
    private String userId;
    @NonNull
    private String deviceId;
    @NonNull
    private State state;


    public EkoPushConfig(@NonNull String userId, @NonNull String deviceId, @NonNull State state) {
        this.userId = userId;
        this.deviceId = deviceId;
        this.state = state;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = userId;
    }

    @NonNull
    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(@NonNull String deviceId) {
        this.deviceId = deviceId;
    }

    @NonNull
    public State getState() {
        return state;
    }

    public void setState(@NonNull State state) {
        this.state = state;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoPushConfig other = (EkoPushConfig) obj;
        return Objects.equal(userId, other.userId)
                && Objects.equal(deviceId, other.deviceId)
                && Objects.equal(state, other.state);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(userId,
                deviceId,
                state);
    }
}
