package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.Nullable;

import org.joda.time.DateTime;

import java.util.List;

public abstract class EkoQueryToken {

    public static final int INVALID_PAGE_NUMBER = -1;

    @Nullable
    private String previous;
    @Nullable
    private String next;

    private int pageNumber = INVALID_PAGE_NUMBER;

    private List<String> ids;

    private DateTime updatedAt;


    @Nullable
    public String getPrevious() {
        return previous;
    }

    public void setPrevious(@Nullable String previous) {
        this.previous = previous;
    }

    @Nullable
    public String getNext() {
        return next;
    }

    public void setNext(@Nullable String next) {
        this.next = next;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public List<String> getIds() {
        return ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public DateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

}
