package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.Entity;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.EkoObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

import org.joda.time.DateTime;

@Entity(tableName = "reaction",
        primaryKeys = {"userId", "reactionName", "referenceType", "referenceId"})
public class EkoReactionEntity extends EkoObject {

    public static final String REACTION_PREFIX = "!";

    // hotfix reactionId not available in myReaction, use first non empty char
    private String reactionId;

    @NonNull
    private String reactionName;

    @NonNull
    private String userId;

    private String userDisplayName;

    @NonNull
    private String referenceId;

    @NonNull
    private String referenceType;

    public EkoReactionEntity() {

    }

    public EkoReactionEntity(String reactionId,
                             @NonNull String referenceType,
                             @NonNull String referenceId,
                             @NonNull String reactionName,
                             @NonNull String userId,
                             String userDisplayName,
                             DateTime createdTime,
                             DateTime updatedTime) {
        this.reactionId = reactionId;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
        this.reactionName = reactionName;
        this.userId = userId;
        this.userDisplayName = userDisplayName;
        this.setCreatedAt(createdTime);
        this.setUpdatedAt(updatedTime);
    }

    @Override
    public String getId() {
        return referenceType + referenceId + reactionName + userId;
    }

    @NonNull
    public String getReferenceType() {
        return referenceType;
    }

    public void setReferenceType(@NonNull ReactionReferenceType referenceType) {
        this.referenceType = referenceType.getValue();
    }

    public void setReferenceType(@NonNull String referenceType) {
        this.referenceType = referenceType;
    }

    @NonNull
    public String getReactionId() {
        return reactionId;
    }

    public void setReactionId(String reactionId) {
        this.reactionId = reactionId;
    }

    @NonNull
    public String getReactionName() {
        return reactionName;
    }

    public void setReactionName(@NonNull String reactionName) {
        this.reactionName = reactionName;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = userId;
    }

    public String getUserDisplayName() {
        return userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @NonNull
    public String getReferenceId() {
        return referenceId;
    }

    public void setReferenceId(@NonNull String referenceId) {
        this.referenceId = referenceId;
    }

    public static EkoReactionEntity createReaction(@NonNull String reactionId,
                                                   @NonNull ReactionReferenceType referenceType,
                                                   @NonNull String referenceId,
                                                   @NonNull String reactionName,
                                                   @NonNull String userId,
                                                   @Nullable String userDisplayName,
                                                   @Nullable DateTime createdAt,
                                                   @Nullable DateTime updatedAt) {

        return EkoReactionEntity.create(reactionId,
                referenceType,
                referenceId,
                reactionName,
                userId,
                userDisplayName,
                createdAt,
                updatedAt);
    }



    public static EkoReactionEntity create( @NonNull String reactionId,
                                            @NonNull ReactionReferenceType referenceType,
                                           @NonNull String referenceId,
                                           @NonNull String reactionName,
                                           @NonNull String userId,
                                           String userDisplayName,
                                           DateTime createdAt,
                                           DateTime updatedAt) {
        return new EkoReactionEntity(reactionId,
                referenceType.getValue(),
                referenceId,
                reactionName,
                userId,
                userDisplayName,
                createdAt,
                updatedAt);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (obj == this) return true;
        if (obj.getClass() != getClass()) return false;
        EkoReactionEntity other = (EkoReactionEntity) obj;
        return Objects.equal(referenceType, other.referenceType)
                && Objects.equal(referenceId, other.referenceId)
                && Objects.equal(reactionName, other.reactionName)
                && Objects.equal(userId, other.userId)
                && Objects.equal(userDisplayName, other.userDisplayName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(
                referenceType,
                referenceId,
                reactionName,
                userId,
                userDisplayName
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("referenceType", referenceType)
                .add("referenceId", referenceId)
                .add("reactionName", reactionName)
                .add("userId", userId)
                .add("userDisplayName", userDisplayName)
                .toString();
    }
}