package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;

import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;

@Entity(tableName = "user_flag",
        primaryKeys = {"userId"},
        foreignKeys = {
                @ForeignKey(entity = UserEntity.class,
                        parentColumns = "userId",
                        childColumns = "userId",
                        onDelete = ForeignKey.CASCADE)
        })
public class EkoUserFlag extends EkoObject {

    @NonNull
    private String userId;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    private EkoLocalFlag localFlag;

    @Override
    public String getId() {
        return null;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = userId;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public void setFlag(EkoFlag flag) {
        this.flag = flag;
    }

    public EkoLocalFlag getLocalFlag() {
        return localFlag;
    }

    public void setLocalFlag(EkoLocalFlag localFlag) {
        this.localFlag = localFlag;
    }

    public boolean isFlaggedByMe() {
        if (flag != null) {
            boolean mightFlaggedByMe = flag.mightFlaggedByMe();

            if (localFlag == null) {
                localFlag = new EkoLocalFlag();
            }

            if (mightFlaggedByMe && !Objects.equal(flag.getHash(), localFlag.getSyncedUpHash())) {
                Single.just(getUserId())
                        .filter(flag::expired)
                        .flatMapSingle(new UserRepository()::isFlaggedByMe)
                        .doOnSuccess(isFlaggedByMe -> {
                            localFlag.setFlaggedByMe(isFlaggedByMe);
                            localFlag.setSyncedUpHash(flag.getHash());
                            UserDatabase.get().userFlagDao().update(this);
                        })
                        .subscribe();

                return true;
            }

            return mightFlaggedByMe && localFlag.isFlaggedByMe();
        } else if (localFlag != null) {
            Completable.fromAction(() -> {
                localFlag = null;
                UserDatabase.get().userFlagDao().update(this);
            })
                    .subscribeOn(Schedulers.io())
                    .subscribe();
        }

        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj)
                && Objects.equal(flag, ((EkoUserFlag) obj).flag)
                && Objects.equal(localFlag, ((EkoUserFlag) obj).localFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), flag, localFlag);
    }

}
