package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.Ignore
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.UserEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "comment")
data class CommentEntity(@PrimaryKey
                                  var commentId: String = ObjectId.get().toHexString(),
                         var path: String = "",
                         var referenceType: String = "",
                         var referenceId: String = "",
                         var userId: String = "",
                         var parentId: String? = null,
                         var rootId: String? = null,
                         var dataType: String = "",
                         var data: JsonObject? = null,
                         var metadata: JsonObject? = null,
                         var childrenNumber: Int = 0,
                         var flagCount: Int = 0,
                         var reactions: AmityReactionMap = AmityReactionMap(),
                         var reactionCount: Int = 0,
                         var isDeleted: Boolean = false,
                         var editedAt: DateTime = DateTime.now(),
                         var syncState: String = AmityComment.State.SYNCED.stateName,
                         var segmentNumber: Int = 0,
                         var mentionees: List<EkoMentioneesDto> = emptyList()) : EkoObject() {

    @Ignore
    private var user: UserEntity? = null

    @Ignore
    private var latestReplies: List<CommentEntity> = listOf()

    override fun getId(): String {
        return commentId
    }
  
    var myReactions: List<String> = emptyList()

    fun setUser(user: UserEntity) {
        this.user = user
    }

    fun getUser(): UserEntity? {
        return user
    }

    fun setLatestReplies(commentEntity: List<CommentEntity>) {
        this.latestReplies = commentEntity
    }

    fun getLatestReplies(): List<CommentEntity> {
        return latestReplies
    }

    fun getRawData(): JsonObject {
        val rawData = data ?: JsonObject()
        rawData.addProperty("commentId", commentId)
        return rawData
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? CommentEntity)?.let { comment ->
            (Objects.equal(commentId, comment.commentId)
                    && Objects.equal(path, comment.path)
                    && Objects.equal(referenceType, comment.referenceType)
                    && Objects.equal(referenceId, comment.referenceId)
                    && Objects.equal(userId, comment.userId)
                    && Objects.equal(parentId, comment.parentId)
                    && Objects.equal(rootId, comment.rootId)
                    && Objects.equal(dataType, comment.dataType)
                    && Objects.equal(data, comment.data)
                    && Objects.equal(metadata, comment.metadata)
                    && Objects.equal(childrenNumber, comment.childrenNumber)
                    && Objects.equal(flagCount, comment.flagCount)
                    && Objects.equal(reactions, comment.reactions)
                    && Objects.equal(reactionCount, comment.reactionCount)
                    && Objects.equal(isDeleted, comment.isDeleted)
                    && Objects.equal(editedAt, comment.editedAt)
                    && Objects.equal(segmentNumber, comment.segmentNumber)
                    && Objects.equal(mentionees, comment.mentionees))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
                commentId,
                path,
                referenceType,
                referenceId,
                userId,
                parentId,
                rootId,
                dataType,
                data,
                metadata,
                childrenNumber,
                flagCount,
                reactions,
                reactionCount,
                isDeleted,
                editedAt,
                segmentNumber,
                mentionees
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("commentId", commentId)
            add("path", path)
            add("referenceType", referenceType)
            add("referenceId", referenceId)
            add("userId", userId)
            add("parentId", parentId)
            add("rootId", rootId)
            add("dataType", dataType)
            add("childrenNumber", childrenNumber)
            add("data", data)
            add("metadata", metadata)
            add("flagCount", flagCount)
            add("reactions", reactions)
            add("reactionCount", reactionCount)
            add("editedAt", editedAt)
            add("syncState", syncState)
            add("segmentNumber", segmentNumber)
            add("mentionees", mentionees)
        }
        return super.internalToString(toStringHelper)
    }

}
