package com.ekoapp.ekosdk.internal.entity

import androidx.annotation.NonNull
import androidx.room.Entity
import androidx.room.Ignore
import com.amity.socialcloud.sdk.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.UserEntity
import com.ekoapp.ekosdk.PermissionEkoObject
import com.ekoapp.ekosdk.RoleEkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId

@Entity(tableName = "community_membership", primaryKeys = ["communityId", "userId"])
class CommunityMembershipEntity : EkoObject(), RoleEkoObject, PermissionEkoObject {

    private var id = ""
    @NonNull
    private var userId: String = ObjectId.get().toHexString()
    var communityId: String = ""
    var channelId: String? = null
    var metadata: JsonObject? = null
    var communityMembership: String? = null
    var isBanned: Boolean? = false
    private var roles: AmityRoles? = null
    private var permissions: AmityPermissions? = null

    @Ignore
    private var user: UserEntity? = null

    override fun getReferenceRoleId(): String {
        return communityId
    }

    override fun getReferencePermissionId(): String {
        return communityId
    }

    override fun getId(): String {
        return id
    }

    fun setId(id: String) {
        this.id = id
    }

    override fun getUserId(): String {
        return userId
    }

    fun setUserId(userId: String) {
        this.userId = userId
    }

    fun setUser(user: UserEntity) {
        this.user = user
    }

    fun getUser(): UserEntity? {
        return user
    }

    override fun getPermissions(): AmityPermissions? {
        return permissions
    }

    fun setPermissions(permissions: AmityPermissions?) {
        this.permissions = permissions
    }

    override fun getRoles(): AmityRoles? {
        return roles
    }

    fun setRoles(roles: AmityRoles?) {
        this.roles = roles
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? CommunityMembershipEntity)?.let { communityMemberShip ->
            (Objects.equal(communityId, communityMemberShip.communityId)
                    && Objects.equal(userId, communityMemberShip.userId)
                    && Objects.equal(channelId, communityMemberShip.channelId)
                    && Objects.equal(metadata, communityMemberShip.metadata)
                    && Objects.equal(communityMembership, communityMemberShip.communityMembership)
                    && Objects.equal(isBanned, communityMemberShip.isBanned)
                    && Objects.equal(roles, communityMemberShip.roles)
                    && Objects.equal(permissions, communityMemberShip.permissions))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
                communityId,
                userId,
                channelId,
                metadata,
                communityMembership,
                isBanned,
                roles,
                permissions
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("communityId", communityId)
            add("userId", userId)
            add("channelId", channelId)
            add("metadata", metadata)
            add("communityMembership", communityMembership)
            add("isBanned", isBanned)
            add("roles", roles)
            add("permissions", permissions)
        }
        return super.internalToString(toStringHelper)
    }

}
