package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.Ignore
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.amity.socialcloud.sdk.video.stream.AmityStream
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.UserEntity
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.mapper.AmityFilePropertiesMapper
import com.ekoapp.ekosdk.internal.mapper.EkoUserMapper
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import org.amity.types.ObjectId

@Entity(tableName = "stream")
open class EkoStreamEntity : EkoObject() {

    @PrimaryKey
    var streamId: String = ObjectId.get().toHexString()
    var title: String? = null
    var description: String? = null
    var metadata: JsonObject? = null
    var isDeleted: Boolean = false
    var thumbnailFileId: String? = null
    var userId: String? = null
    var watcherData: JsonObject? = null
    var broadcasterData: JsonObject? = null
    var recordings: JsonArray? = null
    var status: String? = null
    var isReconnecting: Boolean = false
    var resolution: String? = null


    @Ignore
    private var thumbnailFile: EkoFileEntity? = null

    @Ignore
    private var user: UserEntity? = null

    override fun getId(): String {
        return streamId
    }

    fun setThumbnailFile(thumbnailFile: EkoFileEntity?) {
        this.thumbnailFile = thumbnailFile
    }

    fun getThumbnailImage(): AmityImage? {
        return AmityFilePropertiesMapper().map(thumbnailFile)?.let { AmityImage(thumbnailFileId!!, null, it) }
    }

    fun setUser(user: UserEntity?) {
        this.user = user
    }

    fun getUser(): AmityUser? {
        return user?.let(EkoUserMapper()::map)
    }
    
    fun getStreamStatus(): AmityStream.Status {
        return AmityStream.Status.enumOf(status)
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? EkoStreamEntity)?.let { stream ->
            (Objects.equal(streamId, stream.streamId)
                    && Objects.equal(title, stream.title)
                    && Objects.equal(isReconnecting, stream.isReconnecting)
                    && Objects.equal(description, stream.description)
                    && Objects.equal(thumbnailFileId, stream.thumbnailFileId)
                    && Objects.equal(userId, stream.userId)
                    && Objects.equal(metadata, stream.metadata)
                    && Objects.equal(watcherData, stream.watcherData)
                    && Objects.equal(broadcasterData, stream.broadcasterData)
                    && Objects.equal(recordings, stream.recordings)
                    && Objects.equal(status, stream.status)
                    && Objects.equal(isDeleted, stream.isDeleted)
                    && Objects.equal(resolution, stream.resolution))
        } ?: kotlin.run { false }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(streamId, isReconnecting, title, description,
                metadata, thumbnailFileId, userId, watcherData, broadcasterData,
                recordings, status, resolution)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("streamId", streamId)
            add("isReconnecting", isReconnecting)
            add("title", title)
            add("description", description)
            add("metadata", metadata)
            add("watcherData", watcherData)
            add("broadcasterData", broadcasterData)
            add("recordings", recordings)
            add("thumbnailFileId", thumbnailFileId)
            add("userId", userId)
            add("status", status)
            add("resolution", resolution)
            add("isDeleted", isDeleted)
        }
        return super.internalToString(toStringHelper)
    }
}