package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "global_post")
open class GlobalPostEntity : EkoObject() {

    @PrimaryKey
    var postId: String = ObjectId.get().toHexString()
    var pageNumber = 0
    var rank = 0

    override fun getId(): String {
        return postId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? GlobalPostEntity)?.let { entity ->
            (Objects.equal(postId, entity.postId)
                    && Objects.equal(pageNumber, entity.pageNumber)
                    && Objects.equal(rank, entity.rank))
        } ?: kotlin.run { false }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(postId, pageNumber, rank)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("postId", postId)
            add("pageNumber", pageNumber)
            add("rank", rank)
        }
        return super.internalToString(toStringHelper)
    }

}