package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.core.error.AmityError
import com.ekoapp.ekosdk.EkoObject
import org.amity.types.ObjectId

@Entity(tableName = "tombstone")
class TombstoneEntity : EkoObject() {

    @PrimaryKey
    var objectId: String = ObjectId.get().toHexString()
    var errorCode: Int = AmityError.UNKNOWN.code
    var modelType: String = ""

    override fun getId(): String {
        return objectId + modelType
    }
}