package com.ekoapp.ekosdk.internal.init

import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import com.amity.socialcloud.sdk.push.EkoPushContractWrapper
import com.ekoapp.ekosdk.internal.api.http.AmityUploadService
import com.ekoapp.ekosdk.internal.push.EkoPushContractImpl
import com.ekoapp.ekosdk.internal.util.AppContext
import com.ekoapp.ekosdk.internal.util.RxEko
import io.reactivex.plugins.RxJavaPlugins

object AmityCoreSDKInitializer {


    @Synchronized
    fun init(context: Context) {
        AppContext.init(context)
        initRxJavaPlugins()
        listenToTimeZoneChanges(context)
    }

    private fun listenToTimeZoneChanges(context: Context) {
        context.applicationContext
            .registerReceiver(
                TimeZoneChangedReceiver(),
                IntentFilter(Intent.ACTION_TIMEZONE_CHANGED)
            )
    }

    private fun initRxJavaPlugins() {
        val defaultErrorHandler = RxJavaPlugins.getErrorHandler()
        io.reactivex.rxjava3.plugins.RxJavaPlugins
            .setErrorHandler { t: Throwable ->
                defaultErrorHandler?.accept(t)
                RxEko.LOG_ERROR_CONSUMER.accept(t)
            }
        RxJavaPlugins.setErrorHandler { t: Throwable ->
            defaultErrorHandler?.accept(t)
            RxEko.LOG_ERROR_CONSUMER.accept(t)
        }
    }

    internal fun initApiService() {
        EkoPushContractWrapper.init(EkoPushContractImpl())
        AmityUploadService.initService()
    }

}