package com.ekoapp.ekosdk.internal.keycreator

import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption

class CommentKeyCreator(
    private val referenceId: String,
    private val referenceType: String,
    private val parentId: String?,
    private val isDeleted: Boolean?,
    private val sortOption: AmityCommentSortOption
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "referenceId" to referenceId,
            "referenceType" to referenceType,
            "parentId" to (parentId ?: ""),
            "isDeleted" to (isDeleted ?: false),
            "sortOption" to sortOption.apiKey
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            referenceId = referenceId,
            referenceType = referenceType,
            parentId = parentId,
            isDeleted = isDeleted
        )
    }

    private fun getConditionStatement(
        referenceId: String,
        referenceType: String,
        parentId: String?,
        isDeleted: Boolean?,
    ): String {
        //reference filter
        val referenceFilterStatement = "comment.referenceType = '$referenceType'" +
                " and comment.referenceId = '$referenceId'"
        //isDeleted filter
        var isDeletedFilterStatement = ""
        if (isDeleted == false) {
            isDeletedFilterStatement = " and comment.isDeleted = 0"
        } else if (isDeleted == true) {
            isDeletedFilterStatement = " and comment.isDeleted = 1"
        }
        //parent comment filter
        val parentCommentFilter = if (parentId == null) {
            " and comment.parentId is null"
        } else {
            " and comment.parentId = '$parentId'"
        }
        //compose all condition
        return referenceFilterStatement +
                isDeletedFilterStatement +
                parentCommentFilter
    }
}