package com.ekoapp.ekosdk.internal.keycreator

import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.ekosdk.community.membership.query.AmityCommunityMembership

class CommunityMembershipKeyCreator(
        private val communityId: String,
        private val roles: AmityRoles,
        private val filters: List<AmityCommunityMembership>?,
        private val sortBy: String?,
        private val keyword: String?
) : QueryStreamKeyCreator {
    
    override fun toMap(): Map<String, Any> {
        return mapOf(
                "communityId" to communityId,
                "roles" to roles,
                "memberships" to (filters ?: listOf()),
                "sortBy" to (sortBy ?: ""),
                "search" to (keyword ?: "")
        )
    }
    
    override fun optionalFilterQuery(): String? {
        return "community_membership.communityId = '$communityId'"
    }
}