package com.ekoapp.ekosdk.internal.keycreator

import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter

class FollowingKeyCreator(
    private val userId: String,
    private val followStatusFilter: AmityFollowStatusFilter
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "userId" to userId,
            "followStatusFilter" to followStatusFilter.apiKey,
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        //reference filter
        val userIdFilterStatement = "user_follow.sourceUserId = '$userId'"
        //follow status filter
        val followStatusFilterStatement =
            " and user_follow.status IN (${getFollowStatusesAsArrayString()})"
        //compose all condition
        return userIdFilterStatement +
                followStatusFilterStatement
    }

    private fun getFollowStatusesAsArrayString(): String {
        val typesString = StringBuilder()
        followStatusFilter.statuses.forEachIndexed { index, status ->
            if (index == 0) {
                typesString.append("'$status'")
            } else {
                typesString.append(", '$status'")
            }
        }
        return typesString.toString()
    }
}