package com.ekoapp.ekosdk.internal.keycreator

import com.ekoapp.ekosdk.internal.keycreator.toSqlArray

class StreamKeyCreator(
    private val statuses: List<String>
) : DynamicQueryStreamKeyCreator {
    
    override fun getFilterQuery(): String {
        return "stream.status IN (${statuses.toSqlArray()}) and stream.isDeleted = 0"
    }
    
    override fun toMap(): Map<String, Any> {
        return mapOf("statuses" to statuses)
    }
}