package com.ekoapp.ekosdk.internal.mapper

import com.ekoapp.ekosdk.AmityContentCheck
import com.ekoapp.ekosdk.AmityContentFeedType
import com.ekoapp.ekosdk.AmityContentType
import com.ekoapp.ekosdk.AmityVideoResolution
import com.ekoapp.ekosdk.internal.api.dto.ContentCheckListDto
import com.ekoapp.ekosdk.internal.api.dto.ContentSettingDto

internal class AmityContentSettingModelMapper {

    private fun ContentCheckListDto.mapper(): AmityContentCheck {
        return feedSettings.fold(mutableListOf<AmityContentCheck.FeedType>()) { acc, contentFeedType ->
            val feedType = contentFeedType.feedType.let(AmityContentFeedType::enumOf)
            val contentSettings = feedType?.let { getFeedTypeContentSettings(it, contentFeedType.contentSettings) }
            if (feedType!= null && contentSettings != null) {
                acc.add(contentSettings)
            }
            acc
        }.let { feedTypes ->
            AmityContentCheck(feedTypes = feedTypes)
        }
    }

    fun map(entity: ContentCheckListDto): AmityContentCheck {
        return entity.mapper()
    }
    
    private fun getFeedTypeContentSettings(feedType: AmityContentFeedType, list: List<ContentSettingDto>): AmityContentCheck.FeedType? {
        return if (list.isNotEmpty() ) {
            val text = getTextContentSettings(list)
            val video = getVideoContentSettings(list)
            AmityContentCheck.FeedType(feedType = feedType, text = text, video = video)
        } else {
            null
        }
    }
    
    private fun getTextContentSettings(list: List<ContentSettingDto>): AmityContentCheck.FeedType.Content.TEXT? {
        return list.firstOrNull { it.contentType == AmityContentType.TEXT.apiKey }
                ?.let(::getContentSettings)
                as? AmityContentCheck.FeedType.Content.TEXT
    }
    
    private fun getVideoContentSettings(list: List<ContentSettingDto>): AmityContentCheck.FeedType.Content.VIDEO? {
        return list.firstOrNull { it.contentType == AmityContentType.VIDEO.apiKey }
                ?.let(::getContentSettings)
                as? AmityContentCheck.FeedType.Content.VIDEO
    }
    
    private fun getContentSettings(dto: ContentSettingDto): AmityContentCheck.FeedType.Content? {
        return when(AmityContentType.enumOf(dto.contentType)) {
            AmityContentType.VIDEO -> AmityContentCheck.FeedType.Content.VIDEO(
                    dto.allowed,
                    AmityVideoResolution.enumOf(dto.transcodeConfig?.minResolution),
                    AmityVideoResolution.enumOf(dto.transcodeConfig?.maxResolution),
                    dto.minDurationSeconds,
                    dto.maxDurationSeconds
            )
            AmityContentType.TEXT -> AmityContentCheck.FeedType.Content.TEXT(
                    dto.allowed
            )
            else -> null
        }
    }

}
