package com.ekoapp.ekosdk.internal.mapper

import com.amity.socialcloud.sdk.video.stream.AmityStream
import com.ekoapp.ekosdk.internal.entity.EkoStreamEntity

internal class EkoStreamMapper {

    fun EkoStreamEntity.mapper(): AmityStream {
        return AmityStream(
            streamId = streamId,
            status = getStreamStatus(),
            title = title,
            description = description,
            resolution = resolution,
            thumbnailImage = getThumbnailImage(),
            watcherData = watcherData,
            broadcasterData = broadcasterData,
            recordings = recordings,
            user = getUser(),
            metadata = metadata,
            isDeleted = isDeleted,
            createdAt = createdAt,
            updatedAt = updatedAt
        )
    }

    fun map(entity: EkoStreamEntity): AmityStream {
        return entity.mapper()
    }
}