package com.ekoapp.ekosdk.internal.mapper

import com.amity.socialcloud.sdk.core.user.AmityUser
import com.ekoapp.core.utils.requiredNonNull
import com.ekoapp.ekosdk.UserEntity

internal class EkoUserMapper {

    private fun UserEntity.mapper(): AmityUser {
        return AmityUser(
                mid = mid,
                userId = userId,
                displayName = displayName,
                roles = roles,
                flagCount = flagCount,
                metadata = metadata,
                avatarFileId = avatarFileId,
                avatarCustomUrl = avatarCustomUrl,
                description = description ?: "",
                createdAt = createdAt,
                updatedAt = updatedAt,
                path = path,
                isGlobalBan = isGlobalBan,
                isDeleted = isDeleted
        )
    }

    fun map(entity: UserEntity): AmityUser {
        return entity.mapper()
    }

}
