package com.ekoapp.ekosdk.internal.paging

import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

interface DynamicQueryStreamPagingDao<Entity : Any> : AmityPagingDao<Entity> {

    fun generateQueryStreamSQL(
        tableName: String,
        primaryKeyColumnName: String,
        additionalPrimaryKeys: Map<String, Any> = emptyMap(),
        dynamicQueryStreamKeyCreator: DynamicQueryStreamKeyCreator,
        nonce: Int,
        order: AmityPagingDao.Order,
        sortColumn: String? = null,
    ): SimpleSQLiteQuery {
        return generateSqlQuery(
            tableName = tableName,
            primaryKeyColumnName = primaryKeyColumnName,
            additionalPrimaryKeys = additionalPrimaryKeys,
            queryParameters = dynamicQueryStreamKeyCreator.toMap(),
            nonce = nonce,
            order = order,
            sortColumn = sortColumn,
            additionalFilter = dynamicQueryStreamKeyCreator.getFilterQuery()
        )
    }

    @Deprecated("use generateQueryStreamSQL")
    override fun generateSqlQuery(
        tableName: String,
        primaryKeyColumnName: String,
        additionalPrimaryKeys: Map<String, Any>,
        queryParameters: Map<String, Any>,
        nonce: Int,
        order: AmityPagingDao.Order,
        sortColumn: String?,
        additionalFilter: String?
    ): SimpleSQLiteQuery {
        return super.generateSqlQuery(
            tableName,
            primaryKeyColumnName,
            additionalPrimaryKeys,
            queryParameters,
            nonce,
            order,
            sortColumn,
            additionalFilter
        )
    }
}