package com.ekoapp.ekosdk.internal.paging

import androidx.paging.*
import androidx.paging.rxjava2.flowable
import com.amity.socialcloud.sdk.common.ModelMapper
import com.ekoapp.ekosdk.internal.mediator.QueryStreamMediator
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Flowable
import java.util.concurrent.Executors

@ExperimentalPagingApi
open class QueryStreamPagerCreator<Entity : Any, ResponseDto : Any,
        AmityModel: Any>(
    private val pagingConfig: PagingConfig,
    private val initialKey: Int? = null,
    private val queryStreamMediator: QueryStreamMediator<Entity, ResponseDto>,
    private val pagingSourceFactory: () ->PagingSource<Int, Entity>,
    private val modelMapper: ModelMapper<Entity, AmityModel>
) {

    private fun getPager(): Pager<Int, Entity> {
        return Pager(
            config = pagingConfig,
            initialKey = initialKey,
            remoteMediator = queryStreamMediator,
            pagingSourceFactory = pagingSourceFactory
        )
    }

    open fun create(): Flowable<PagingData<AmityModel>> {
        return getPager().flowable
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) {
                    modelMapper.map(it)
                }
            }
    }
}