package com.ekoapp.ekosdk.internal.repository.channel

import androidx.paging.DataSource
import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.chat.channel.AmityChannelSortOption
import com.amity.socialcloud.sdk.chat.data.channel.ChannelComposerFunction
import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase

@Deprecated("To be removed with pagedlist")
internal class EkoChannelFactory(
    val isDeleted: Boolean?,
    private val types: Set<AmityChannel.Type>,
    filter: AmityChannelFilter,
    private val includingTags: AmityTags,
    private val excludingTags: AmityTags,
    val sortBy: AmityChannelSortOption
) {

    private val channelDao = UserDatabase.get().channelDao()
    private val memberships = filter.memberships

    fun getDataSource(): DataSource.Factory<Int, AmityChannel> {
        return getDataSourceEntity()
            .map(
                ChannelComposerFunction()
            )
    }

    fun getChannelType(): Array<String> {
        var typeSet = types
        if (types.isEmpty()) {
            typeSet = AmityChannel.Type.values().toSet()
        }
        return typeSet.map(AmityChannel.Type::apiKey).toTypedArray()
    }

    private fun getDataSourceEntity(): DataSource.Factory<Int, EkoChannelEntity> {
        return channelDao.getDataSource(
            AmityCoreClient.getUserId(),
            getChannelType(),
            includingTags,
            excludingTags,
            memberships,
            isDeleted
        )
    }

}