package com.ekoapp.ekosdk.internal.repository.comment.helper

import androidx.paging.DataSource
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.entity.CommentEntity

internal class EkoCommentFactory {

    fun getFactory(referenceId: String,
                   referenceType: String,
                   isFilterByParentId: Boolean,
                   parentId: String?,
                   isDeleted: Boolean?,
                   sortOption: AmityCommentSortOption): DataSource.Factory<Int, AmityComment> {

        return getFactoryEntity(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption)
                .map(CommentComposerFunction())

    }

    private fun getFactoryEntity(referenceId: String,
                                 referenceType: String,
                                 isFilterByParentId: Boolean,
                                 parentId: String?,
                                 isDeleted: Boolean?,
                                 sortOption: AmityCommentSortOption): DataSource.Factory<Int, CommentEntity> {
        return getCommentsFactory(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption)
    }

    private fun getCommentsFactory(referenceId: String,
                                   referenceType: String,
                                   isFilterByParentId: Boolean,
                                   parentId: String?,
                                   isDeleted: Boolean?,
                                   sortOption: AmityCommentSortOption): DataSource.Factory<Int, CommentEntity> {

        val commentDao = UserDatabase.get().commentDao()

        return if (isFilterByParentId) {
            commentDao.getAllByParentId(referenceType, referenceId, parentId, isDeleted, sortOption)
        } else {
            commentDao.getAll(referenceType, referenceId, isDeleted, sortOption)
        }
    }
}