package com.ekoapp.ekosdk.internal.usecase.channel

import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.channel.AmityChannelCreator
import com.amity.socialcloud.sdk.chat.channel.ChannelCreateOption
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelComposerUseCase
import io.reactivex.rxjava3.core.Single

internal class CreateChannelWithChannelIdUseCase {

    fun execute(channelId: String,
                creationType: AmityChannelCreator.CreationType,
                option: ChannelCreateOption): Single<AmityChannel> {
        return ChannelRepository().createChannel(channelId, creationType, option)
            .map {
                ChannelComposerUseCase().execute(it)
            }
    }

}