package com.ekoapp.ekosdk.internal.usecase.channel

import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.channel.ChannelCreateOption
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelComposerUseCase
import io.reactivex.rxjava3.core.Single

internal class CreateConversationWithUserIdsUseCase {

    fun execute(option: ChannelCreateOption): Single<AmityChannel> {
        return ChannelRepository().createConversationChannel(option)
            .map {
                ChannelComposerUseCase().execute(it)
            }
    }

}