package com.ekoapp.ekosdk.internal.usecase.channel

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMember
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipFilter
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipSortOption
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import io.reactivex.rxjava3.core.Flowable

internal class GetChannelMembershipPagedListUseCase {

    fun execute(
        channelId: String,
        roles: AmityRoles,
        filter: AmityChannelMembershipFilter,
        sortOption: AmityChannelMembershipSortOption
    ): Flowable<PagedList<AmityChannelMember>> {
        return ChannelMembershipRepository().getChannelMembershipPagedList(
            channelId = channelId,
            roles = roles,
            memberships = filter.memberships,
            isMuted = filter.isMuted,
            sortOption = sortOption
        )
    }

}