package com.ekoapp.ekosdk.internal.usecase.channel

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMember
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipFilter
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipSortOption
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.amity.socialcloud.sdk.chat.domain.channel.membership.ChannelMemberComposerUseCase
import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetChannelMembershipPagingSourceUseCase {

    fun execute(
        channelId: String,
        filter: AmityChannelMembershipFilter,
        roles: AmityRoles,
        sortOption: AmityChannelMembershipSortOption
    ): Flowable<PagingData<AmityChannelMember>> {
        return ChannelMembershipRepository().getChannelMembershipPagingData(
            channelId = channelId,
            memberships = filter.memberships,
            isMuted = filter.isMuted,
            roles = roles,
            sortOption = sortOption
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { channelMember ->
                ChannelMemberComposerUseCase().execute(channelMember)
            }
        }
    }
}