package com.ekoapp.ekosdk.internal.usecase.channel

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.chat.channel.AmityChannelSortOption
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import io.reactivex.rxjava3.core.Flowable

internal class GetChannelPagedListUseCase {

    fun execute(isDeleted: Boolean?,
                types: Set<AmityChannel.Type>,
                filter: AmityChannelFilter,
                includingTags: AmityTags,
                excludingTags: AmityTags,
                sortBy: AmityChannelSortOption): Flowable<PagedList<AmityChannel>> {
        return ChannelRepository().getChannelPagedList(
                isDeleted,
                types,
                filter,
                includingTags,
                excludingTags,
                sortBy)
    }
}