package com.ekoapp.ekosdk.internal.usecase.channel

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMember
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembership
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipFilter
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.amity.socialcloud.sdk.chat.domain.channel.membership.ChannelMemberComposerUseCase
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class SearchChannelMembershipPagingSourceUseCase {

    fun execute(
        channelId: String,
        memberships: List<AmityChannelMembership>,
        roles: AmityRoles,
        keyword: String
    ): Flowable<PagingData<AmityChannelMember>> {
        return ChannelMembershipRepository().searchChannelMembershipPagingData(
            channelId = channelId,
            memberships = memberships.filterNot { it == AmityChannelMembership.MUTED }.map { AmityMembershipType.enumOf(it.apiKey) },
            isMuted = if(memberships.contains(AmityChannelMembership.MUTED)) true else null,
            roles = roles,
            keyword = keyword
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { channelMember ->
                ChannelMemberComposerUseCase().execute(channelMember)
            }
        }
    }

}