package com.ekoapp.ekosdk.internal.usecase.comment

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption

import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import io.reactivex.Flowable

internal class CommentListQueryUseCase {
    fun execute(referenceId: String,
                referenceType: String,
                isFilterByParentId: Boolean,
                parentId: String?,
                isDeleted: Boolean?,
                sortOption: AmityCommentSortOption): Flowable<PagedList<AmityComment>> {

        return CommentRepository().getCommentCollection(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption)
    }
}