package com.ekoapp.ekosdk.internal.usecase.comment

import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import io.reactivex.rxjava3.core.Single

internal class CommentManualFirstPageLoadUseCase {

    fun execute(referenceId: String,
                referenceType: String,
                isFilterByParentId: Boolean,
                parentId: String?,
                isDeleted: Boolean?,
                sortOption: AmityCommentSortOption,
                limit: Int
    ): Single<CommentLoadResult> {

        return CommentRepository().loadFirstPageComments(referenceType,
                referenceId,
                isFilterByParentId,
                parentId,
                isDeleted,
                sortOption,
                limit
        ).map {
            markOutDatedIsDeletedStatus(isDeleted, sortOption, it)
            it
        }
    }

    private fun markOutDatedIsDeletedStatus(isDeleted: Boolean?, sortOption: AmityCommentSortOption, commentResult: CommentLoadResult) {
        if (commentResult.ids.isNotEmpty() && isDeleted != null && isDeleted == false) {
            if (sortOption == AmityCommentSortOption.FIRST_CREATED) {
                CommentRepository().markDeletedBeforeCommentId(commentResult.ids.first())
            } else {
                CommentRepository().markDeletedAfterCommentId(commentResult.ids.first())
            }
        }
    }

}